package com.androidbook.simpletelephony;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class SendSMSActivity extends Activity {
    
    BroadcastReceiver rcvMsgSent = null;
    BroadcastReceiver rcvMsgReceipt = null;
    
    BroadcastReceiver rcvIncoming = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.sms);

        final EditText messageEntry = (EditText) findViewById(R.id.short_message);

        final SmsManager sms = SmsManager.getDefault();
        
        // Sformatowanie numeru
        final EditText numberEntry = (EditText) findViewById(R.id.number_entry);
        numberEntry.addTextChangedListener(new PhoneNumberFormattingTextWatcher());

        // Przygotowanie intencji odbierających
        Intent msgSent = new Intent("ACTION_MSG_SENT");
        Intent msgReceipt = new Intent("ACTION_MSG_RECEIPT");

        final PendingIntent pendingMsgSent = PendingIntent.getBroadcast(this, 0, msgSent, 0);
        final PendingIntent pendingMsgReceipt = PendingIntent.getBroadcast(this, 0, msgReceipt, 0);

        // Obsługa przycisku Wyślij
        Button sendSMS = (Button) findViewById(R.id.send_sms);
        sendSMS.setOnClickListener(new View.OnClickListener() {

            public void onClick(View v) {
                String destination = numberEntry.getText().toString();
                String message = messageEntry.getText().toString();
                sms.sendTextMessage(destination, null, message, pendingMsgSent, pendingMsgReceipt);
                
                
                if (rcvMsgSent != null) {
                    unregisterReceiver(rcvMsgSent);
                    rcvMsgSent = null;
                }

                // Odbieranie informacji o zmianach statusu.
                rcvMsgSent = new BroadcastReceiver() {

                    @Override
                    public void onReceive(Context context, Intent intent) {
                        int result = getResultCode();
                        if (result != Activity.RESULT_OK) {
                            Log.e("Telefonia", "Kod błędu wysyłania SMS-a = " + result);
                            pendingMsgReceipt.cancel();
                        } else {
                            Log.i("Telefonia", "SMS wysłany!");
                            messageEntry.setText("");
                        }

                    }
                };
                registerReceiver(rcvMsgSent, new IntentFilter("ACTION_MSG_SENT"));
            }

        });
        
        
        final TextView receivedMessage = (TextView)findViewById(R.id.received_message);
        rcvIncoming = new BroadcastReceiver() {

            @Override
            public void onReceive(Context context, Intent intent) {
                Log.i("Telefonia", "Odebrano SMS");
                Bundle data = intent.getExtras();
                if (data != null) {
                    // SMSy używają formatu danych nazywanego PDU
                    Object pdus[] = (Object[]) data.get("pdus");
                    String message = "Nowa wiadomość:\n";
                    String sender = null;
                    for (Object pdu : pdus) {
                        SmsMessage part = SmsMessage.createFromPdu((byte[])pdu);
                        message += part.getDisplayMessageBody();
                        if (sender == null) {
                            sender = part.getDisplayOriginatingAddress();
                        }
                    }
                    receivedMessage.setText(message+"\nOd: "+sender);
                    numberEntry.setText(sender);
                }
            }
        };
        registerReceiver(rcvIncoming, new IntentFilter("android.provider.Telephony.SMS_RECEIVED"));
        
        
    }

    @Override
    protected void onPause() {
        try {
        if (rcvMsgSent != null) {
            unregisterReceiver(rcvMsgSent);
            rcvMsgSent = null;
        }
        } catch (Exception e) {
            Log.e("Telefonia", "Nie udało się wyrejestrować rcvMsgSent", e);
        }
        try {
        if (rcvMsgReceipt != null) {
            unregisterReceiver(rcvMsgSent);
            rcvMsgReceipt = null;
        }
        } catch(Exception e) {
            Log.e("Telefonia", "Nie udało się wyrejestrować rcvMsgReceipt", e);
            
        }
        
        try {
            if (rcvIncoming != null) {
                unregisterReceiver(rcvIncoming);
                rcvIncoming = null;
            }
            } catch (Exception e) {
                Log.e("Telefonia", "Nie udało się wyrejestrować rcvIncoming", e);
            }
        super.onStop();
    }

}
